/* --------------------------------------------------------------
   hermeshsi_ordersoverview.js 2019-10-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

$(function () {
	'use strict';
	
	const $table = $('.orders .table-main');
	
	$table.on('init.dt', function () {
		const _initSingleAction = function ($theTable) {
			$theTable.find('.btn-group.dropdown').each(function () {
				const orderId = $(this).parents('tr').data('id'),
					defaultRowAction = $theTable.data('init-default-row-action') || 'edit';
				
				jse.libs.button_dropdown.addAction($(this), {
					text: jse.core.lang.translate('hermeshsi_ordersoverview_hermeshsi_label', 'module_center_module'),
					href: jse.core.config.get('appUrl') + '/admin/admin.php?do=HermesHSI/PrepareLabel&oID=' + orderId,
					class: 'hermeshsi-single',
					data: {configurationValue: 'hermeshsi-single'},
					isDefault: defaultRowAction === 'hermeshsi-single',
				});
			});
		}

		$table.on('draw.dt', () => _initSingleAction($table));
		_initSingleAction($table);
	});
});
